% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForkRate.R
\docType{methods}
\name{ForkRate}
\alias{ForkRate}
\alias{ForkRate,aRchi-method}
\title{Compute the fork rate of a tree}
\usage{
ForkRate(aRchi)

\S4method{ForkRate}{aRchi}(aRchi)
}
\arguments{
\item{aRchi}{a file of class aRchi with at least a QSM and a Path table.}
}
\value{
a vector with two numeric value. The number of Fork and the fork rate.
}
\description{
Compute the fork rate from an aRchi object
}
\details{
The fork rate is the mean number of forks per meter of tree height. This metric is computed by browsing tree QSM from the base to the top. Each time a ramification point is encountered it is evaluated as a fork if at least one daughter had a radius not less than 75\% of the diameter of the largest daughter. This threshold was chosen in order to exclude non-perennial structures, such as traumatic or epicormic shoots, or branches that will not last on the tree. If the ramification point is a fork, all retained daughter branches are browsed through until the next ramification point and further until the path end. If a daughter is rejected, it is removed as well as all the paths passing through it.
}
\examples{
# Read an aRchi file with a QSM and paths tables.
file=system.file("extdata","Tree_1_aRchi.aRchi",package = "aRchi")
Tree1_aRchi=read_aRchi(file)
# Compute the fork rate of Tree1
ForkRate(Tree1_aRchi)
}
\references{
Martin-Ducup, O. et al. Terrestrial laser scanning reveals convergence of tree architecture with increasingly dominant crown canopy position. Functional Ecology (2020).
}
\seealso{
\code{\link{Clean_QSM}} to clean a QSM based on a threshold of percentage of largest daughter's diameter.
}
