% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Make_Node.R
\docType{methods}
\name{Make_Node}
\alias{Make_Node}
\alias{Make_Node,aRchi-method}
\title{Make Node}
\usage{
Make_Node(aRchi, all_combination = FALSE)

\S4method{Make_Node}{aRchi}(aRchi, all_combination = FALSE)
}
\arguments{
\item{aRchi}{a file of class aRchi containing at least a QSM}

\item{all_combination}{logical (default = \code{FALSE}). Should the node metrics be computed at each combination of distance from the node ? (see details).}
}
\value{
The aRchi file with the Nodes slot filled.
}
\description{
Compute several node metrics (i.e Leonardo's ratio and WBE parameters) from an object aRchi at different distance from the node.
}
\details{
The Nodes slot contains a list of two data.table (Absolute_positions and Relative_positions). Each data.tables contains for each node several values of Leonardo's rule ratio (R_ratio), radius scaling exponent (alpha), length scaling exponent (beta) and the estimated metabolic rate (theta) which are parameters of the West Brown and Enquist metabolic theory (see Bentley et al. 2013, Lau et al 2019 and Martin-Ducup et al. 2020).

For a given node, each R_ratio and alpha correspond to its value estimated with the branch radius (for alpha) or the cross section area (for R_ratio) at a given position from the node for the parent (pos_parent) and for the daughters (pos_daugthers). The positions (i.e pos_parent and pos_daughters) are the distances in meters (for Absolute_position data.table) or in percentage (for Relative_position data.table) from the node (i.e the ramification point) to the point of radius or cross section area estimation. These positions are given at a 10 cm step and cannot be higher than the length of the shorter segment among the couple daughters/parent for Absolute_position and at a 10\% step for the Relative_position.

Kriging models are used to estimate radius (and thus cross section area) along the segment positions. For example pos_parent = 0.2 and pos_daugthers = 0.2 for Absolute_position data.table means that the parameters (i.e R_ratio and alpha) have been estimated at 20cm from the node position for the parent and 20 cm from the node position for the daughters. For the Relative_position data.table, this position is given in proportion to the total length of the segment. For example, pos_parent = 0.5 and pos_daughter = 0.5 means that the parameters are estimated at mid_length of the segments for both the parent and the daughters).

beta values are repeated for each node as it depend on segment length only and not on radius position.

If \code{all_combination = TRUE} all the possible combination for pos_parent and pos_daughter are computed (e.g pos_parent = 0.3 and pos_daughter = 0.5) but note that this processing might take several minutes and is \code{FALSE} by default.
}
\examples{
\donttest{
# Read a QSM file
file=system.file("extdata","Tree_1_TreeQSM.txt",package = "aRchi")
QSM=read_QSM(file,model="treeQSM")
# Build an object of class aRchi
Tree1_aRchi<-build_aRchi(QSM=QSM)
Tree1_aRchi
# Make the node table
Tree1_aRchi<-Make_Node(Tree1_aRchi)
Tree1_aRchi
# WBE parameters at the tree level
LeonardoRatio(Tree1_aRchi)
}

}
\references{
Martin-Ducup, O. et al. Terrestrial laser scanning reveals convergence of tree architecture with increasingly dominant crown canopy position. Functional Ecology (2020).

	Lau, A. et al. Estimating architecture-based metabolic scaling exponents of tropical trees using terrestrial LiDAR and 3D modelling. Forest Ecology and Management 439, 132–145 (2019).

	Bentley, L. P. et al. An empirical assessment of tree branching networks and implications for plant allometric scaling models. Ecology Letters 16, 1069–1078 (2013).
}
\seealso{
\code{\link{WBEparameters}} to estimates WBE parameters at different level; \code{\link{LeonardoRatio}} to estimates Leonardo Da Vinci's ratio  at different level.
}
