% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_circlemap.R
\name{canvas_circlemap}
\alias{canvas_circlemap}
\title{Paint a Circle Map on a Canvas}
\usage{
canvas_circlemap(colors, x_min = 0, x_max = 12.56, y_min = 0, y_max = 1, 
                 iterations = 10, width = 1500, height = 1500)
}
\arguments{
\item{colors}{a character specifying the color used for the function shape.}

\item{x_min}{a numeric value specifying the minimum value for the x-axis.}

\item{x_max}{a numeric value specifying the maximum value for the x-axis.}

\item{y_min}{a numeric value specifying the minimum value for the y-axis.}

\item{y_max}{a numeric value specifying the maximum value for the y-axis.}

\item{iterations}{the number of iterations.}

\item{width}{the width of the artwork in pixels.}

\item{height}{the height of the artwork in pixels.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function is my attempt at a circle map.
}
\examples{
\donttest{
canvas_circlemap(colors = colorPalette('tuscany2'))
}

}
\references{
\url{https://linas.org/art-gallery/circle-map/circle-map.html}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
