% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_diamonds.R
\name{canvas_diamonds}
\alias{canvas_diamonds}
\title{Draw Diamonds}
\usage{
canvas_diamonds(
  colors,
  background = "#fafafa",
  col.line = "black",
  radius = 10,
  alpha = 1,
  p = 0.2,
  resolution = 500
)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the background.}

\item{col.line}{a character specifying the color of the diamond borders.}

\item{radius}{a positive value specifying the radius of the diamonds.}

\item{alpha}{a value specifying the transparency of the diamonds. If \code{NULL} (the default), added layers become increasingly more transparent.}

\item{p}{a value specifying the probability of drawing an empty diamond.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws diamonds on a canvas and (optionally) places two lines behind them. The diamonds can be transparent or have a random color sampled from the input.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_diamonds(colors = colorPalette("tuscany1"))
}

}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
