\name{aTSA}
\alias{aTSA}
\alias{aTSA}
\docType{package}
\title{
Alternative Time Series Analysis
}
\description{
This is an alternative package to analyze the time series data, especially the univariate time series. Compared with other existing functions for time series analysis, most functions in this package provide nice outputs like SAS does for time series. Several functions are exactly the same names as 'arima' procedure in SAS, such as \code{\link{identify}}, \code{\link{estimate}}, and \code{\link{forecast}}, etc. They also have the similar outputs.
}
\details{
\tabular{ll}{
Package: \tab aTSA\cr
Type: \tab Package\cr
Version: \tab 3.1.2\cr
Date: \tab 2015-06-19\cr
License: \tab GPL-2 | GPL-3\cr
}
For a complete list of functions and dataset, use \code{library(help = aTSA)}.
}
\author{
Debin Qiu

Maintainer: Debin Qiu <debinqiu@uga.edu>

}
\references{
Engle, Robert F.; Granger, Clive W. J. (1987). Co-integration and error correction: Representation, estimation and testing. \emph{Econometrica}, 55 (2): 251-276.

Engle, Robert F. (1982). Autoregressive Conditional Heteroscedasticity with Estimates of the Variance of United Kingdom Inflation. \emph{Econometrica}, 50 (4): 987-1007.

Fuller, W. A. (1976). Introduction to Statistical Time Series. New York: John Wiley and Sons.

Hobijn B, Franses PH and Ooms M (2004). Generalization of the KPSS-test for stationarity. \emph{Statistica Neerlandica}, vol. 58, p. 482-502.

Kwiatkowski, D.; Phillips, P. C. B.; Schmidt, P.; Shin, Y. (1992). 
Testing the null hypothesis of stationarity against the alternative of a unit root. \emph{Journal of Econometrics}, 54 (1-3): 159-178.

McLeod, A. I. and W. K. Li. Diagnostic Checking ARMA Time Series Models Using Squared-Residual Autocorrelations. \emph{Journal of Time Series Analysis}. Vol. 4, 1983, pp. 269-27.

Phillips, P. C. B.; Perron, P. (1988). Testing for a Unit Root in Time Series Regression. \emph{Biometrika}, 75 (2): 335-346.
}
\keyword{ package }

