% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getResults.R
\name{getResults}
\alias{getResults}
\title{Get Results}
\usage{
getResults(output="", save_to_file=TRUE)
}
\arguments{
\item{output}{Optional; folder to which you want to save the data from the processed images; Default is same folder as the script}

\item{save_to_file}{Required; Default is TRUE; If true, it saves to file. Otherwise returns a data frame with results + other attributes from Abbyy}
}
\value{
data frame returned by \code{\link{listFinishedTasks}} plus either a column that contains paths to local files (when writing to disk), 
or actual results returned.
}
\description{
Get data from all the processed images.
}
\details{
The function calls \code{\link{listFinishedTasks}}, goes through the finishedTasks data frame and downloads all the files in resultsUrl
Results can be stored in memory or written to the hard disk. By default, the function writes to the disk. 
If the user wants the results to be written to disk, a data frame with paths to local file paths is returned. If the user wants to store the 
results in memory, data frame with a column carrying the results is returned.
}
\examples{
\dontrun{
getResults(save_to_file=FALSE)
}
}
\references{
\url{http://ocrsdk.com/documentation/apireference/getTaskStatus/}
}
