% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{carefully}
\alias{carefully}
\title{Vectorized, parallel, safe and verbose function factory}
\usage{
carefully(.f, p = 0.05, cores = 1)
}
\arguments{
\item{.f}{Function to be wrapped}

\item{p}{Probability of function printing the index of the input it's
currently processing}

\item{cores}{Number of cores to use when iterating over vectorized
inputs}
}
\description{
Wraps a function so that iterating over a set of inputs is
easily parallelizable, and interruption-free.
}
\examples{
\dontrun{
# Function that takes a string and pastes two other strings
# a its beginning and end respectivelly
pad <- function(str, b = "", a = "") { paste0(b, str, a) }

# Create wrapped version of pad() that executes over 4 cores,
# captures errors, and prints its current iteration with a
# probability of 50\%
new_pad <- carefully(pad, p = 0.5, cores = 4)

# Execute new_pad() with some sample data
new_pad(c("asdf", "poiu", "qwer"), b = "0", a = "1")
}

}
