% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{FCV}
\alias{FCV}
\title{Dataset related to Feline calicivirus infection among cats in Switzerland.}
\format{
An adapted data frame of the original dataset, which consists of 300 observations of 15 variables.
\describe{
\item{FCV}{Feline Calici Virus status (0/1).}
\item{FHV_1}{Feline Herpes Virus 1 status (0/1). }
\item{C_felis}{C-felis and Chlamydia felis status (0/1).}
\item{M_felis}{Mycoplasma felis status (0/1).}
\item{B_bronchiseptica}{B-bronchiseptica & Bordetella bronchispetica status (0/1).}
\item{FeLV}{feline leukosis virus status (0/1).}
\item{FIV}{feline immunodeficiency virus status (0/1).}
\item{Gingivostomatitis}{gingivostomatitis complex status (0/1).}
\item{URTD}{URTD complex (upper respiratory complex) (0/1).}
\item{Vaccinated}{vaccination status (0/1).}
\item{Pedigree}{pedigree (0/1).}
\item{Outdoor}{outdoor access (0/1).}
\item{Sex}{sex and castrated status (M, MN, F, FS).}
\item{GroupSize}{number of cats in the group (counts).}
\item{Age}{age in year (continuous)\.}
}
}
\usage{
FCV
}
\description{
The dataset is about the Feline calicivirus (FCV) infection among cats in Switzerland.
FCV is a virus that occurs worldwide in domestic cats but also in exotic felids.
FCV is a highly contagious virus that is the major cause of upper respiratory
disease or cat flue that affects felids. This is a complex disease caused by
different viral and bacterial pathogens, i.e., FCV, FHV-1, \emph{Mycoplasma felis},
\emph{Chlamydia felis} and \emph{Bordetella bronchiseptica}.
It can be aggravated by retrovirus infections such as FeLV and FIV.
This composite dynamic makes it very interesting for a BN modeling approach.
The data were collected between September 2012 and April 2013.
}
\references{
Berger, A., Willi, B., Meli, M. L., Boretti, F. S., Hartnack, S., Dreyfus, A., ... and Hofmann-Lehmann, R. (2015). Feline calicivirus and other respiratory pathogens in cats with Feline calicivirus-related symptoms and in clinically healthy cats in Switzerland. BMC Veterinary Research, 11(1), 282.
}
\keyword{datasets}
