% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sequential.R
\name{plot_sequential}
\alias{plot_sequential}
\title{Plot Sequential Analysis}
\usage{
plot_sequential(x, thin = 1, ...)
}
\arguments{
\item{x}{object of class \code{"ab"}. Note that the \code{"ab"} object needs
to contain sequential data, that is, the user needs to have provided
cumulative sequences of "successes"/trials.}

\item{thin}{allows the user to skip every \eqn{k}th data point for plotting,
where the number \eqn{k} is specified via \code{thin}. For instance, in
case \code{thin = 2}, only every second element of the data is displayed.}

\item{...}{further arguments}
}
\description{
Function for plotting the posterior probabilities of the hypotheses
sequentially.
}
\details{
The plot shows the posterior probabilities of the hypotheses as a
  function of the total number of observations across the experimental and
  control group. On top of the plot, probability wheels (see also
  \code{\link{prob_wheel}}) visualize the prior probabilities of the
  hypotheses and the posterior probabilities of the hypotheses after taking
  into account all available data.
}
\examples{
### 1.

# synthetic sequential data (observations alternate between the groups)
# note that the cumulative number of successes and trials need to be provided
data <- list(y1 = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 3, 3, 4, 4),
             n1 = c(1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10),
             y2 = c(0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9),
             n2 = c(0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10))

# conduct Bayesian A/B test with default settings
ab <- ab_test(data = data)
print(ab)

# produce sequential plot of posterior probabilities of the hypotheses
plot_sequential(ab)

\donttest{

# example of good width and height values for saving to file
cairo_pdf(file.path(tempdir(), "test_plot.pdf"),
          width = 530 / 72, height = 400 / 72)
plot_sequential(ab)
dev.off()

}

\dontrun{

### 2.
data(seqdata)

# conduct Bayesian A/B test with default settings
ab2 <- ab_test(data = seqdata)
print(ab2)

# produce sequential plot of posterior probabilities of the hypotheses
plot_sequential(ab2, thin = 4)

# example of good width and height values for saving to file
cairo_pdf(file.path(tempdir(), "test_plot2.pdf"),
          width = 530 / 72, height = 400 / 72)
plot_sequential(ab2)
dev.off()

}
}
\author{
Quentin F. Gronau
}
