% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_posterior.R
\name{plot_posterior}
\alias{plot_posterior}
\title{Plot Posterior}
\usage{
plot_posterior(x, what = "logor", hypothesis = "H1", ci = 0.95,
  p1lab = "p1", p2lab = "p2", p1adj = 0.44, p2adj = 0.56, ...)
}
\arguments{
\item{x}{object of class \code{"ab"}.}

\item{what}{character specifying for which quantity the posterior should be
plotted. Either \code{"logor"} (i.e., log odds ratio) , \code{"or"} (i.e.,
odds ratio), \code{"p1p2"} (i.e., the marginal posteriors of the latent
"success" probabilities in the experimental and control condition),
\code{"rrisk"} (i.e., relative risk, the ratio of the "success" probability
in the experimental and the control condition), or \code{"arisk"} (i.e.,
absolute risk, the difference of the "success" probability in the
experimental and control condition).}

\item{hypothesis}{character specifying whether to plot the two-sided
posterior distribution (i.e., "H1"), the one-sided posterior distribution
with lower truncation point (i.e., "H+"), or the one-sided posterior
distribution with upper truncation point (i.e., "H-").}

\item{ci}{numeric value specifying the \code{ci}\% central credible interval.
The default is 0.95 which yields a 95\% central credible interval.}

\item{p1lab}{determines p1 x-axis label. Only relevant for \code{what =
"p1p2"}.}

\item{p2lab}{determines p2 x-axis label. Only relevant for \code{what =
"p1p2"}.}

\item{p1adj}{determines p1 x-axis label adjustment. Only relevant for
\code{what = "p1p2"}.}

\item{p2adj}{determines p2 x-axis label adjustment. Only relevant for
\code{what = "p1p2"}.}

\item{...}{further arguments}
}
\description{
Function for plotting the posterior distribution.
}
\details{
The resulting plot displays the posterior density for the quantitiy
  of interest and also displays the corresponding prior density. The values
  of the posterior median and a \code{ci}\% central credible interval are
  displayed on top of the plot.
}
\examples{
# synthetic data
data <- list(y1 = 10, n1 = 28, y2 = 14, n2 = 26)

# Bayesian A/B test with default settings
ab <- ab_test(data = data, posterior = TRUE)

# plot parameter posterior
plot_posterior(x = ab, what = "logor")
plot_posterior(x = ab, what = "or")
plot_posterior(x = ab, what = "p1p2")
plot_posterior(x = ab, what = "rrisk")
plot_posterior(x = ab, what = "arisk")

\donttest{
  # example of good width and height values for saving to file
  cairo_pdf(file.path(tempdir(), "test_plot.pdf"),
            width = 530 / 72, height = 400 / 72)
  plot_posterior(ab, what = "p1p2")
  dev.off()
}
}
\author{
Quentin F. Gronau
}
