% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_video_tweetsv2.R
\name{get_video_tweets}
\alias{get_video_tweets}
\title{Get tweets for query containing videos}
\usage{
get_video_tweets(
  query,
  start_tweets,
  end_tweets,
  bearer_token,
  file = NULL,
  data_path = NULL,
  bind_tweets = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{query}{string or character vector, search query or queries}

\item{start_tweets}{string, starting date}

\item{end_tweets}{string, ending date}

\item{bearer_token}{string, bearer token}

\item{file}{string, name of the resulting RDS file}

\item{data_path}{string, if supplied, fetched data can be saved to the designated path as jsons}

\item{bind_tweets}{If \code{TRUE}, tweets captured are bound into a data.frame for assignment}

\item{verbose}{If \code{FALSE}, query progress messages are suppressed}

\item{...}{arguments will be passed to \code{build_query()} function. See \code{?build_query()} for further information.}
}
\value{
a data frame
}
\description{
This function collects tweets containing strings or hashtags between specified date ranges
that also contain native Twitter videos, uploaded directly to Twitter. This will not match
on videos created with Periscope, or Tweets with links to other video hosting sites. Tweet-level
data is stored in a data/ path as a series of JSONs beginning "data_"; User-level data is stored
as a series of JSONs beginning "users_". If a filename is supplied, this function will save the
result as a RDS file, otherwise it will return the results as a dataframe.
}
\examples{
\dontrun{
bearer_token <- "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
get_video_tweets("#BLM", "2020-01-01T00:00:00Z", "2020-01-05T00:00:00Z", 
                  bearer_token, data_path = "data/")
}
}
