% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinalFunctions.R
\name{genDat}
\alias{genDat}
\title{Generate data for ordinal examples in the package}
\usage{
genDat(numClasses, numObsPerClass, mu, sigma)
}
\arguments{
\item{numClasses}{Positive integer specifying the number of classes for the
dataset.}

\item{numObsPerClass}{Number of observations sampled per class.}

\item{mu}{Mean of the first class.}

\item{sigma}{2 by 2 covariance matrix}
}
\value{
\code{genDat} Returns a list with the following attributes:
    \describe{
      \item{X}{A matrix with two columns and \code{numObsPerClass}*\code{numClasses} rows.}
      \item{Y}{Labels for the rows of \code{X}.}
      }
}
\description{
Given the parameters, the function creates a dataset for testing the ordinal functionality
of the package. The data is samples from multivariate Gaussians with different means, where
the mean varies along a sinusoidal curve w.r.t. the class label.
}
\details{
This function is used to demonstrate the usage of the ordinal classifier.
}
\examples{
set.seed(123)

    # You can play around with these values to generate some 2D data to test one
    numClasses <- 15
    sigma <- matrix(c(1,-0.2,-0.2,1),2,2)
    mu <- c(0,0)
    numObsPerClass <- 5

    # Generate the data, can access with train$X and train$Y
    train <- accSDA::genDat(numClasses,numObsPerClass,mu,sigma)
    test <- accSDA::genDat(numClasses,numObsPerClass*2,mu,sigma)

    # Visualize it, only using the first variable gives very good separation
    plot(train$X[,1],train$X[,2],col = factor(train$Y),asp=1,main="Training Data")

}
\seealso{
\code{\link{ordASDA}}
}
\author{
Gudmundur Einarsson
}
