% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cut_counts}
\alias{cut_counts}
\title{Cut Count Values into Intensity Ranges}
\usage{
cut_counts(counts, int_cuts = as.integer(c(100, 760, 2020, 5999)))
}
\arguments{
\item{counts}{Integer vector with accelerometer count values.}

\item{int_cuts}{Numeric vector with four cutpoints from which five intensity 
ranges are derived. For example, \code{int_cuts = c(100, 760, 2020, 5999)} 
creates: 0-99 = intensity 1; 100-759 = intensity level 2; 760-2019 = 
intensity 3; 2020-5998 = intensity 4; >= 5999 = intensity 5.}
}
\value{
Integer vector.
}
\description{
Given a vector of accelerometer count values, classifies each count value 
into intensity level 1, 2, 3, 4, or 5 (typically representing sedentary, 
light, lifestyle, moderate, and vigorous).
}
\examples{
# Load accelerometer data for first 5 participants in NHANES 2003-2004
data(unidata)

# Get data from ID number 21005
counts.part1 <- unidata[unidata[, "seqn"] == 21005, "paxinten"]

# Cut into 5 intensity levels and plot
intensity.part1 <- cut_counts(counts = counts.part1)
plot(intensity.part1)


}
