% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgt_poverty.R
\name{fgt_poverty}
\alias{fgt_poverty}
\title{Foster-Greer-Thorbecke (FGT) poverty measures}
\usage{
fgt_poverty(
  accessibility_data,
  sociodemographic_data,
  opportunity,
  population,
  poverty_line,
  group_by = character(0)
)
}
\arguments{
\item{accessibility_data}{A data frame. The accessibility levels whose
poverty levels should be calculated. Must contain the columns \code{id} and any
others specified in \code{opportunity}.}

\item{sociodemographic_data}{A data frame. The distribution of
sociodemographic characteristics of the population in the study area cells.
Must contain the columns \code{id} and any others specified in \code{population}.}

\item{opportunity}{A string. The name of the column in \code{accessibility_data}
with the accessibility levels to be considerend when calculating
accessibility poverty.}

\item{population}{A string. The name of the column in \code{sociodemographic_data}
with the number of people in each cell. Used to weigh accessibility levels
when calculating poverty.}

\item{poverty_line}{A \code{numeric}. The poverty line below which individuals are
considered to be in accessibility poverty.}

\item{group_by}{A \code{character} vector. When not \code{character(0)} (the default),
indicates the \code{accessibility_data} columns that should be used to group the
poverty estimates by. For example, if \code{accessibility_data} includes a
\code{race} column that specifies the racial category of the population (e.g.
\code{"black"} and \code{"white"}) that each entry refers to, passing \code{"race"} to
this parameter results in poverty estimates grouped by race.}
}
\value{
A data frame containing the three poverty estimates (FGT0, FGT1 and
FGT2) for the study area.
}
\description{
Calculates the FGT metrics, a family of poverty measures originally proposed
by \insertCite{foster1984class;textual}{accessibility} that capture the
extent and severity of poverty within an accessibility distribution. The FGT
family is composed of three measures that differ based on the \eqn{\alpha}
parameter used to calculate them (either 0, 1 or 2) and which also changes
their interpretation. Please see the details section for more information on
the interpretation of the measures.
}
\section{Interpretation of FGT measures}{

The interpretation of each FGT measure depends on the \eqn{\alpha} parameter
used to calculate it:
\itemize{
\item with \eqn{\alpha = 0} (FGT0) the measure captures the \emph{extent} of poverty
as a simple headcount - i.e. the proportion of people below the poverty line;
\item with \eqn{\alpha = 1} (FGT1) the measure, also know as the "poverty gap
index", captures the \emph{severity} of poverty as the average percentage distance
between the poverty line and the accessibility of individuals below the
poverty line;
\item with \eqn{\alpha = 2} (FGT2) the measure simultaneously captures the
\emph{extent} and the \emph{severity} of poverty by calculating the number of people
below the poverty line weighted by the size of the accessibility shortfall
relative to the poverty line.
}

FGT values range from 0 to 1. A value of 0 indicates that every individual is
above the poverty line. When every individual is below the poverty line,
however, FGT0 value is 1 and FGT1 and FGT2 values approach 1.
}

\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data_dir <- system.file("extdata", package = "accessibility")
travel_matrix <- readRDS(file.path(data_dir, "travel_matrix.rds"))
land_use_data <- readRDS(file.path(data_dir, "land_use_data.rds"))

access <- cumulative_cutoff(
  travel_matrix,
  land_use_data,
  cutoff = 30,
  opportunity = "jobs",
  travel_cost = "travel_time"
)

poverty <- fgt_poverty(
  access,
  opportunity = "jobs",
  sociodemographic_data = land_use_data,
  population = "population",
  poverty_line = 95368
)
poverty
\dontshow{\}) # examplesIf}
}
\references{
\insertAllCited{}
}
