% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_normalize.R
\name{normalize}
\alias{normalize}
\title{Normalize transcriptions}
\usage{
normalize(
  x,
  showProgress = TRUE,
  path_replacementMatrixCSV = "",
  updateX = TRUE
)
}
\arguments{
\item{x}{Corpus object.}

\item{showProgress}{Logical; if \code{TRUE} the progress bar will be displayed.}

\item{path_replacementMatrixCSV}{Character string; path to replacement matrix in CSV format. If empty, the default replacement matrix that comes with the package will be used.}

\item{updateX}{Logical; If \code{TRUE} the original corpus object passed as x to the function will also be updated! If you do not want this, set to \code{FALSE}.}
}
\description{
Normalizes the contents of transcriptions in a corpus using a normalization matrix.
Function returns a corpus object with normalized transcription and updates the original corpus object passed as argument to x.
}
\examples{
library(act)

examplecorpus <- act::normalize(x=examplecorpus)

}
