% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snippets_printtranscript.R
\name{snippets_printtranscript}
\alias{snippets_printtranscript}
\title{Create a single print transcript}
\usage{
snippets_printtranscript(
  t,
  startSec = -1,
  endSec = -1,
  insert_arrow_dataID = "",
  header_heading = "",
  header_firstinfo = "",
  filepath = "",
  alignBrackets = FALSE
)
}
\arguments{
\item{t}{Transcript object.}

\item{startSec}{Double, start of selection in seconds, -1 for no selection.}

\item{endSec}{Double, end of selection in seconds, -1 for no selection.}

\item{insert_arrow_dataID}{Integer; ID of the data row in front of which the arrow will be placed.}

\item{header_heading}{Character string; text that will be used as heading.}

\item{header_firstinfo}{Character string; text that will used as first information in the header.}

\item{filepath}{Character string; path where to save the transcript.}

\item{alignBrackets}{Logical; if \code{TRUE} the function will align [] brackets that signal overlapping speech (attention: experimental function; results may not satisfy)}
}
\value{
Character string; transcript as text.
}
\description{
Create a single print transcript
}
\examples{
library(act)

# Get a transcript
t <- examplecorpus@transcripts[[1]]

# Create print transcript
printtranscript <- act::snippets_printtranscript (t=t)

# Display on screen
cat(stringr::str_c(printtranscript, sep="\n", collapse = "\n"))

}
