% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcripts_cure.R
\name{transcripts_cure}
\alias{transcripts_cure}
\title{Cure a corpus}
\usage{
transcripts_cure(
  x,
  filterTranscriptNames = NULL,
  annotationsWithReversedTimes = TRUE,
  overlappingAnnotations = TRUE,
  annotationsWithTimesBelowZero = TRUE,
  missingTiers = TRUE,
  showWarning = FALSE
)
}
\arguments{
\item{x}{Corpus object.}

\item{filterTranscriptNames}{Vector of character strings; names of the transcripts to be included.}

\item{annotationsWithReversedTimes}{Logical; If \code{TRUE} annotations with reversed times will be deleted}

\item{overlappingAnnotations}{Logical; If \code{TRUE} overlapping annotations will be corrected.}

\item{annotationsWithTimesBelowZero}{Logical; If \code{TRUE} annotations before 0 sec will be corrected.}

\item{missingTiers}{Logical; If \code{TRUE} tiers missing in \code{@tiers} slot of the transcript object will be added.}

\item{showWarning}{Logical; If \code{TRUE} a warning notice will be shown upon correction.}
}
\value{
Corpus object;
}
\description{
Transcript object may contain errors, e.g. because of defect annotation input files or user modifications.
This function may cure some of these errors in all transcript objects of a corpus.
- Annotations with reversed times: annotations with \code{endSec} lower than \code{startSec} will be deleted.
- Overlapping annotations: earlier annotations will end where the next annotation starts.
- Annotations below 0 sec: Annotations that are starting and ending before 0 sec will be deleted; Annotations starting before but ending after 0 sec will be truncated.
- Missing tiers: Tiers that are present in the annotations but missing in the list of tiers in \code{@tiers} of the transcript object will be added.
}
\examples{
library(act)

# The example corpus does not contain any errors.
# But let's use the function anyway.
x<-act::transcripts_cure(examplecorpus)
x@history[[length(x@history)]]

# See \code{act::cure_transcript} for actual examples.

}
\seealso{
\link{transcripts_cure_single}
}
