% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{package}
\name{activity}
\alias{activity}
\alias{activity-package}
\title{Animal activity statistics}
\description{
Provides functions to estimate and compare activity parameters from sensor data.
}
\details{
Sensors that record active animals (eg camera traps) build up a record of
the distribution of activity over the course of the day. Records are more frequent
when animals are more active, and less frequent or absent when animals are inactive.
The area under the distribution of records thus contains information on the overall
level of activity in a sampled population. This package provides tools for plotting
activity distributions, quantifying the overall level of activity with error, and
statistically comparing distributions through bootstrapping.

The core function is \code{fitact}, which creates an \code{actmod} object containing
the circular kernel PDF, and the activity level estimate derived from this. The
generic plot function for \code{actmod} objects plots the distribution. Functions
starting with \code{compare} make statistical comparisons between distributions or
activity estimates. Note that all time or other circular data should be in radians
(in the range 0 to 2*pi).
}
\references{
Rowcliffe, M., Kays, R., Kranstauber, B., Carbone, C., Jansen, P.A. (2014) Quantifying animal activity level using camera trap data. Methods in Ecology and Evolution.
}
\seealso{
\code{\link{overlap}}
}

