% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code_1_1.r
\name{compareCkern}
\alias{compareCkern}
\title{Compare circular distributions.}
\usage{
compareCkern(y1, y2, reps = 1000, index = c("Dhat4", "Dhat5", "Dhat1"))
}
\arguments{
\item{y1, y2}{Numeric vectors of radian data.}

\item{reps}{Number of bootstrap iterations.}

\item{index}{Which of the three indices returned by overlap::overlapEst to use.}
}
\value{
A named 2-element vector: Overlap = observed overlap index; p = probability observed index arose by chance.
}
\description{
Randomisation test for the probability that two sets of circular observations come from the same distribution.
}
\details{
Calculates overlap index (see references) for the observed data samples, then generates a null distribution of overlap indices using data sampled randomly with replacement from the combined data. This randomised distribution is then used to estimate the probability that the observed overlap arose by chance.
}
\examples{
#Example with bootstrap reps limited to speed up
data(BCItime)
tPaca <- 2*pi*BCItime$time[BCItime$species=="paca"]
tRat <- 2*pi*BCItime$time[BCItime$species=="rat"]
compareCkern(tPaca,tRat,reps=10)
}
\references{
Ridout, M.S. & Linkie, M. (2009) Estimating overlap of daily activity patterns from camera trap data. Journal of Agricultural Biological and Environmental Statistics, 14, 322-337.
}
\seealso{
\code{\link{overlapEst}}
}

