% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_metrics_ecdf.R
\name{plot_metrics_ecdf}
\alias{plot_metrics_ecdf}
\title{Plot empirical cumulative distribution functions of performance metrics}
\usage{
plot_metrics_ecdf(
  object,
  metrics = c("size", "sum_ys", "ratio_ys"),
  restrict = NULL,
  nrow = NULL,
  ncol = NULL,
  cores = NULL
)
}
\arguments{
\item{object}{\code{trial_results} object, output from the \code{\link[=run_trials]{run_trials()}}
function.}

\item{metrics}{the performance metrics to plot, as described in
\code{\link[=extract_results]{extract_results()}}. Multiple metrics may be plotted at the same time.
Valid metrics include: \code{size}, \code{sum_ys}, and \code{ratio_ys_mean}. All may be
specified using either spaces or underlines (case sensitive). Defaults to
plotting all three.}

\item{restrict}{single character string or \code{NULL}. If \code{NULL} (default),
results are summarised for all simulations; if \verb{"superior}, results are
summarised for simulations ending with superiority only; if \code{"selected"},
results are summarised for simulations ending with a selected arm only
(according to the specified arm selection strategy for simulations not
ending with superiority). Some summary measures (e.g., \code{prob_conclusive})
have substantially different interpretations if restricted, but are
calculated nonetheless.}

\item{nrow, ncol}{the number of rows and columns when plotting multiple
metrics in the same plot (using faceting in \code{ggplot2}). Defaults to \code{NULL},
in which case this will be determined automatically.}

\item{cores}{\code{NULL} or single integer. If \code{NULL}, a default value set by
\code{\link[=setup_cluster]{setup_cluster()}} will be used to control whether extractions of simulation
results are done in parallel on a default cluster or sequentially in the
main process; if a value has not been specified by \code{\link[=setup_cluster]{setup_cluster()}},
\code{cores} will then be set to the value stored in the global \code{"mc.cores"}
option (if previously set by \verb{options(mc.cores = <number of cores>}), and
\code{1} if that option has not been specified.\cr
If \code{cores = 1}, computations
will be run sequentially in the primary process, and if \code{cores > 1}, a new
parallel cluster will be setup using the \code{parallel} library and removed
once the function completes. See \code{\link[=setup_cluster]{setup_cluster()}} for details.}
}
\value{
A \code{ggplot2} plot object.
}
\description{
Plots empirical cumulative distribution functions (ECDFs) of numerical
performance metrics across multiple simulations from a \code{"trial_results"}
object returned by \code{\link[=run_trials]{run_trials()}}. Requires the \code{ggplot2} package installed.
}
\examples{
#### Only run examples if ggplot2 is installed ####
if (requireNamespace("ggplot2", quietly = TRUE)){

  # Setup a trial specification
  binom_trial <- setup_trial_binom(arms = c("A", "B", "C", "D"),
                                   control = "A",
                                   true_ys = c(0.20, 0.18, 0.22, 0.24),
                                   data_looks = 1:20 * 100)

  # Run multiple simulation with a fixed random base seed
  res_mult <- run_trials(binom_trial, n_rep = 25, base_seed = 678)

  # NOTE: the number of simulations in this example is smaller than
  # recommended - the plots reflect that, and would likely be smoother if
  # a larger number of trials had been simulated

  # Plot ECDFs of continuous performance metrics
  plot_metrics_ecdf(res_mult)

}

}
\seealso{
\code{\link[=check_performance]{check_performance()}}, \code{\link[=summary]{summary()}}, \code{\link[=extract_results]{extract_results()}},
\code{\link[=plot_convergence]{plot_convergence()}}, \code{\link[=check_remaining_arms]{check_remaining_arms()}}.
}
