% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp_opt.R
\name{pow_abs_dist}
\alias{pow_abs_dist}
\title{Calculates matrix of absolute distances raised to a power}
\usage{
pow_abs_dist(x1, x2 = x1, pow = 2)
}
\arguments{
\item{x1}{numeric vector, with length corresponding to the number of rows in
the returned matrix.}

\item{x2}{numeric vector, with length corresponding to the number of columns
in the returned matrix. If not specified, \code{x1} will be used for \code{x2}.}

\item{pow}{single numeric value, the power that all distances are raised to.
Defaults to \code{2}, corresponding to pairwise, squared, Euclidean distances.}
}
\value{
Matrix with \code{length(x1)} rows and \code{length(x2)} columns including the
calculated absolute pairwise distances raised to \code{pow}.
}
\description{
Used internally, calculates the absolute distances for values in a matrix
with possibly unequal dimensions, and raises these to a power.
}
\keyword{internal}
