% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roi_dea.R
\name{roi_dea}
\alias{roi_dea}
\title{Build (standard) DEA problem using ROI infraestructure}
\usage{
roi_dea(input, output, orientation, solver)
}
\arguments{
\item{input}{A matrix or a data frame containing the inputs of the units to be evaluated, with one row for each DMU and one column for each input.}

\item{output}{A matrix or a data frame containing the outputs of the units to be evaluated, with one row for each DMU and one column for each output.}

\item{orientation}{Use "input" for input orientation or "output" for output orientation in DEA model.
The default is "input".}

\item{solver}{a solver to be used by ROI to solve the DEA optimization problem. Use <code>ROI_installed_solvers()</code> to list them.}
}
\value{
list(lp, status, solver, ux, vy, eff)
}
\description{
This function works like dea but without strict parameter check.
}
\details{
Unlike the dea function, this function expects input and output to be arrays or data.frames, not vectors.

Note: As this function is mainly for internal use, to avoid unnecessary overload, it does not do an extensive check of the input parameters. Use the higher level dea function instead.
}
\keyword{internal}
