% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.r
\name{adeba}
\alias{adeba}
\title{Make ADEBA density estimate}
\usage{
adeba(data, adaptive = TRUE, beta = 0.5, parallel, na.rm = FALSE, ...)
}
\arguments{
\item{data}{Dataset with examples as rows and dimensions as columns, supplied as
a matrix or something that can be converted to a matrix, like a
\code{vector}, \code{data.frame} or \code{data.table}.}

\item{adaptive}{Whether to used fixed bandwidths identical for all kernels,
or adaptive bandwidths unique to each kernel. Can also be specified as a
positive integer to iterate beyond the adaptive estimate (see the original
publication).}

\item{beta}{The level of adaptiveness.
The default value of 0.5 corresponds to Silverman's square root law, which
is suitable for the normal distribution.
Can also be specified as multiple
equispaced values, automatically weighted by the Bayesian machinery
(the equispace requirement is for the integral approximation to hold).}

\item{parallel}{Whether to use multiple CPU cores for calculation, using
\code{\link[parallel]{mclapply}} and \code{\link[parallel]{mcMap}} of the \code{parallel}
package. To control the number of cores please use the \code{mc.cores}
option. If unset, all cores will be used.}

\item{na.rm}{Whether to let missing values break execution (\code{FALSE}) or
to remove them from calculations (\code{TRUE}).}

\item{...}{Sent to the internal function \code{make.adeba}.}
}
\value{
A density estimate.
}
\description{
Make ADEBA density estimate
}
\examples{

# Univariate
x.train <- c(rnorm(20, 0, .5), rnorm(20, 2, 2))
f <- adeba(x.train, beta = 0:2/2)

curve((dnorm(x, 0, .5) + dnorm(x, 2, 2))/2, -2, 7, lwd=5, col="grey85")
plot(f, type="both", add=TRUE)
points(f)

# Bi-variate
x.train <- 3 + sweep(matrix(rnorm(60), 30), 2, 1:2, "*") \%*\% matrix(c(1, .4, .4, 1), 2)
x.test <- 3 + sweep(matrix(rnorm(40), 20), 2, 1:2, "*") \%*\% matrix(c(1, .4, .4, 1), 2)
f <- adeba(x.train, adaptive=FALSE)
f <- render(f)

plot(f, type="both")
points(x.test[,1], x.test[,2], cex=10*predict(f, x.test), pch=19)
legend("topleft", c("Traning", "Test"), pch=c(1,19), bg="white")

# Draw random sample from the estimated density
x.new <- radeba(400, f)
plot(f)
points(x.new[,1], x.new[,2])

# Slice the distribution
plot(0, 0, type="n", xlim=c(-4, 12), ylim=c(0, 0.15))
for(i in -6:16){
    f <- render(f, list(seq(-4, 12, length.out=200), i))
    plot(f, col=hsv(h=(i+6)/30), add=TRUE)
}
plot(f, type="data")

# See package `adebaExtra` for how to plot in full 3d

}
\seealso{
\code{\link{predict.adeba}}, \code{\link{render}}, \code{\link{radeba}}
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
