% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moran.bounds.R
\name{moran.bounds}
\alias{moran.bounds}
\title{Function to compute extreme values of Moran's I}
\usage{
moran.bounds(listw)
}
\arguments{
\item{listw}{an object of class \code{listw}}
}
\value{
A vector containing the maximum and minimum of Moran's I for a given spatial weighting matrix value returned
}
\description{
This function computes the upper and lower bounds of Moran's I for a given spatial weighting matrix (stored in a \code{listw} object).
These values are obtained by the eigendecomposition of the spatial weighting matrix.
}
\examples{

if(require("ade4", quietly = TRUE)){
 if(require("spdep", quietly = TRUE)){
     data(oribatid)
     nbtri <- tri2nb(as.matrix(oribatid$xy))
     lwB <- nb2listw(nbtri, style = "B")
     lwW <- nb2listw(nbtri, style = "W")
     scB <- mem(lwB)
     scW <- mem(lwW)
     moran.bounds(lwB)
     moran.mc(scB[,1], lwB, 9)
     moran.mc(scB[,69], lwB, 9)
     moran.bounds(lwW)
     moran.mc(scW[,1], lwW, 9)
     moran.mc(scW[,69], lwW, 9)
 }
}

}
\references{
de Jong, P., Sprenger, C., & van Veen, F. (1984). On extreme values of Moran’s I and Geary's C. Geographical Analysis, 16(1), 17–24.
}
\seealso{
\code{\link{mem}} \code{\link[spdep]{nb2listw}}
}
\author{
Stéphane Dray \email{stephane.dray@univ-lyon1.fr}
}
\keyword{spatial}
