% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_extreme_date.R
\name{date_source}
\alias{date_source}
\title{Create a \code{date_source} object}
\usage{
date_source(
  dataset_name,
  filter = NULL,
  date,
  traceability_vars = NULL,
  set_values_to = NULL
)
}
\arguments{
\item{dataset_name}{The name of the dataset, i.e. a string, used to search for
the date.}

\item{filter}{An unquoted condition for filtering \code{dataset}.}

\item{date}{A variable or an expression providing a date. A date or a
datetime can be specified. An unquoted symbol or expression is expected.}

\item{traceability_vars}{A named list returned by \code{exprs()} defining the
traceability variables, e.g. \code{exprs(LALVDOM = "AE", LALVSEQ = AESEQ, LALVVAR = "AESTDTC")}. The values must be a symbol, a character string, a numeric,
an expression, or \code{NA}.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use \code{set_values_to} instead.}

\item{set_values_to}{Variables to be set}
}
\value{
An object of class \code{date_source}.
}
\description{
Create a \code{date_source} object as input for \code{derive_var_extreme_dt()} and
\code{derive_var_extreme_dtm()}.
}
\examples{

# treatment end date from ADSL
trt_end_date <- date_source(
  dataset_name = "adsl",
  date = TRTEDT
)

# lab date from LB where assessment was taken, i.e. not "NOT DONE"
lb_date <- date_source(
  dataset_name = "lb",
  filter = LBSTAT != "NOT DONE" | is.na(LBSTAT),
  date = convert_dtc_to_dt(LBDTC)
)

# death date from ADSL including traceability variables
death_date <- date_source(
  dataset_name = "adsl",
  date = DTHDT,
  set_values_to = exprs(
    LALVDOM = "ADSL",
    LALVVAR = "DTHDT"
  )
)
}
\seealso{
\code{\link[=derive_var_extreme_dtm]{derive_var_extreme_dtm()}}, \code{\link[=derive_var_extreme_dt]{derive_var_extreme_dt()}}

Source Objects: 
\code{\link{basket_select}()},
\code{\link{censor_source}()},
\code{\link{death_event}},
\code{\link{dthcaus_source}()},
\code{\link{event_joined}()},
\code{\link{event_source}()},
\code{\link{event}()},
\code{\link{query}()},
\code{\link{records_source}()},
\code{\link{tte_source}()}
}
\concept{source_specifications}
\keyword{source_specifications}
