% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_character_scalar}
\alias{assert_character_scalar}
\title{Is an Argument a Character Scalar (String)?}
\usage{
assert_character_scalar(
  arg,
  values = NULL,
  case_sensitive = TRUE,
  optional = FALSE
)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{values}{A \code{character} vector of valid values for \code{arg}.
Values is converted to a lower case vector if case_sensitive = FALSE is used.}

\item{case_sensitive}{Should the argument be handled case-sensitive?
If set to \code{FALSE}, the argument is converted to lower case for checking the
permitted values and returning the argument.}

\item{optional}{Is the checked argument optional? If set to \code{FALSE} and \code{arg}
is \code{NULL} then an error is thrown}
}
\value{
The function throws an error if \code{arg} is not a character vector or if \code{arg}
is a character vector but of length > 1 or if its value is not one of the \code{values}
specified. Otherwise, the input is returned invisibly.
}
\description{
Checks if an argument is a character scalar and (optionally) whether it matches
one of the provided \code{values}.
}
\examples{
example_fun <- function(msg_type) {
  assert_character_scalar(msg_type, values = c("warning", "error"))
}

example_fun("warning")

try(example_fun("message"))

try(example_fun(TRUE))

# handling arguments case-insensitive
example_fun2 <- function(msg_type) {
  msg_type <- assert_character_scalar(
    msg_type,
    values = c("warning", "error"),
    case_sensitive = FALSE
  )
  if (msg_type == "warning") {
    print("A warning was requested.")
  }
}

example_fun2("Warning")
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_date_vector}()},
\code{\link{assert_expr_list}()},
\code{\link{assert_expr}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function_param}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\concept{assertion}
\keyword{assertion}
