% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly_orthonormal_basis.R
\name{poly_orthonormal_basis}
\alias{poly_orthonormal_basis}
\title{Build an orthonormal basis to decompose some given probability density function}
\usage{
poly_orthonormal_basis(
  support = c("Real", "Integer", "Positive", "Bounded.continuous", "Bounded.discrete"),
  deg,
  x,
  m
)
}
\arguments{
\item{support}{Support of the random variables implied in the two-component mixture distribution.}

\item{deg}{Degree up to which the basis is built.}

\item{x}{(NULL by default) Only used when support is 'Integer'. The point at which the polynomial value will be evaluated.}

\item{m}{(NULL by default) Only used when support is 'Integer'. Corresponds to the mean of the reference measure, i.e. Poisson(m).}
}
\value{
the orthonormal polynomial basis used to decompose the density of the unknown component of the mixture distribution.
}
\description{
Build an orthonormal basis, needed to decompose the probability density function (pdf) of the unknown component
from the admixture, depending on the support under consideration.
}
\examples{
poly_orthonormal_basis(support = 'Real', deg = 10, x = NULL, m = NULL)

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
