#' 
#' @title Example data from CarboCATLite
#' 
#' @description
#' Data exported from CarboCATLite model run, equivalent to scenario A from Hohmann et al. (2024). See therein for details.
#' 
#' @format A list with the following fields:
#'  * _time_myr_ : time points in Myr from the model run
#'  * _height_2_km_offshore_m_ : sediment thickness accumulated 2 km from shore  
#'  * _height_4_km_offshore_m_ :  sediment thickness accumulated 4 km from shore   
#'  * _height_6_km_offshore_m_ :  sediment thickness accumulated 6 km from shore 
#'  * _height_8_km_offshore_m_ :  sediment thickness accumulated 8 km from shore 
#'  * _height_10_km_offshore_m_ :  sediment thickness accumulated 10 km from shore 
#'  * _height_12_km_offshore_m_ :  sediment thickness accumulated 12 km from shore 
#'  * _eustatic_SL_m_ : eustatic sea level used for the model run.
#' 
#' @source Elapsed model time, sea level, and accumulated sediment thickness taken from
#' the [scenario A model run here](https://github.com/MindTheGap-ERC/CarboCATLite/tree/scenarioA)
#' 
#' @references
  #' * Burgess, Peter. "CarboCAT: A cellular automata model of heterogeneous carbonate strata." Computers & geosciences 53 (2013): 129-140. \doi{10.1016/j.cageo.2011.08.026}
  #' * Burgess, Peter. (2023). CarboCATLite (v1.0.1). Zenodo. \doi{10.5281/zenodo.8402578}
  #' * Hohmann, Niklas; Koelewijn, Joël R.; Burgess, Peter; Jarochowska, Emilia. 2024. "Identification of the mode of evolution in incomplete carbonate successions." BMC Ecology and Evolution 24, 113. \doi{10.1186/s12862-024-02287-2}.
#' * Hohmann, Niklas, Koelewijn, Joël R.; Burgess, Peter; Jarochowska, Emilia. 2023. “Identification of the Mode of Evolution in Incomplete Carbonate Successions - Supporting Data.” Open Science Framework. \doi{10.17605/OSF.IO/ZBPWA}, published under the [CC-BY 4.0](https://creativecommons.org/licenses/by/4.0/) license.


"CarboCATLite_data"