% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_users.R
\name{get_users}
\alias{get_users}
\title{Get list of users}
\usage{
get_users(company_id = Sys.getenv("AW_COMPANY_ID"), limit = 10, page = 0)
}
\arguments{
\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID} exists in \code{.Renviron} or
elsewhere and no \code{company_id} argument is provided, then the \code{AW_COMPANY_ID} value will be used.
Use \code{\link{get_me}} to get a list of available \code{company_id} values.}

\item{limit}{The number of results to return per page. This argument works in conjunction with the
\code{page} argument. The default is 10.}

\item{page}{The "page" of results to display. This works in conjunction with the \code{limit} argument and is
zero-based. For instance, if \code{limit = 20} and \code{page = 1}, the results returned would be 21 through 40.}
}
\value{
A data frame of users and their meta data.
}
\description{
Retrieves a list of all users for the company designated by the auth token.
}
\examples{
\dontrun{
get_users(limit = 10, page = 0)
}

}
