% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PointMassPrior.R
\docType{class}
\name{PointMassPrior-class}
\alias{PointMassPrior-class}
\alias{PointMassPrior}
\title{Univariate discrete point mass priors}
\usage{
PointMassPrior(theta, mass, label = NA_character_)
}
\arguments{
\item{theta}{numeric vector of pivot points with positive prior mass}

\item{mass}{numeric vector of probability masses at the pivot points
(must sum to 1)}

\item{label}{object label (string)}
}
\value{
an object of class \code{PointMassPrior}, \code{theta} is
automatically sorted in ascending order
}
\description{
\code{PointMassPrior} is a sub-class of \code{\link[=Prior-class]{Prior}}
representing a univariate prior over a discrete set of points with positive
probability mass.
}
\section{Slots}{

\describe{
\item{\code{theta}}{cf. parameter 'theta'}

\item{\code{mass}}{cf. parameter 'mass'}
}}

\examples{
PointMassPrior(c(0, .5), c(.3, .7))

}
\seealso{
To represent continuous prior distributions use \code{\link{ContinuousPrior}}.
}
