% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prior.R, R/ContinuousPrior.R,
%   R/PointMassPrior.R
\name{condition}
\alias{condition}
\alias{condition,ContinuousPrior,numeric-method}
\alias{condition,PointMassPrior,numeric-method}
\title{Condition a prior on an interval}
\usage{
condition(dist, interval, ...)

\S4method{condition}{ContinuousPrior,numeric}(dist, interval, ...)

\S4method{condition}{PointMassPrior,numeric}(dist, interval, ...)
}
\arguments{
\item{dist}{a univariate \code{\link[=DataDistribution-class]{distribution}} object}

\item{interval}{length-two numeric vector giving the parameter interval to
condition on}

\item{...}{further optional arguments}
}
\value{
conditional \code{\link{Prior}} on given interval
}
\description{
Restrict an object of class \code{\link{Prior}} to a sub-interval and
re-normalize the PDF.
}
\examples{
tmp <- condition(
    ContinuousPrior(function(x) dunif(x, .2, .4), c(.2, .4)),
    c(.3, .5)
)
bounds(tmp) # c(.3, .4)

tmp <- condition(PointMassPrior(c(0, .5), c(.3, .7)), c(-1, .25))
expectation(tmp, identity) # 0

}
