% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrib-dpareto2-estimators.R
\name{dpareto2_estimate_mle}
\alias{dpareto2_estimate_mle}
\title{Parameter Estimation in the Discretized Pareto-Type II Distribution Family (MLE)}
\usage{
dpareto2_estimate_mle(x, k0 = 1, s0 = 1, kmin = 1e-04,
  smin = 1e-04, kmax = 100, smax = 100)
}
\arguments{
\item{x}{a non-negative numeric vector}

\item{k0, s0}{initial points for the L-BFGS-B method}

\item{kmin, kmax}{lower and upper bound for the shape parameter to look for}

\item{smin, smax}{lower and upper bound for the scale parameter to look for}
}
\value{
a numeric vector  with the following named components:
\itemize{
\item \code{k} - estimated parameter of shape
\item \code{s} - estimated parameter of scale
}
or \code{c(NA, NA)} if the maximum of the likelihood function
could not be found.
}
\description{
Finds the maximum likelihood estimator of the Discretized Pareto Type-II distribution's
shape parameter \eqn{k} and scale parameter \eqn{s}.
}
\details{
Note that the maximum of the likelihood function may not exist
for some input vectors. This estimator may have large mean squared error.
}
\seealso{
Other DiscretizedPareto2: \code{\link{rdpareto2}}
}
\concept{DiscretizedPareto2}
