% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createNc.R
\name{createNc}
\alias{createNc}
\title{Creation of NetCDF from an array}
\usage{
createNc(arr, varunit, varname, longname, lons, lats, inidate = NULL,
  scale = NULL, out)
}
\arguments{
\item{arr}{array containing the values to export in netcdf.}

\item{varunit}{character. units in which variable is measured.}

\item{varname}{character. name of the variable}

\item{longname}{character. long name of the variable}

\item{lons}{numeric. vector of longitudes.}

\item{lats}{numeric. vector of latitudes.}

\item{inidate}{date. initial day of observations.}

\item{scale}{character. temporal units for the variable (usually "days", "months" or "years")}

\item{out}{character. path to the output file.}
}
\value{
A NetCDF file is created in the path specified in the "out" parameter.
}
\description{
Creates a NetCDF file from an array with values.
}
\examples{

\donttest{
createNc(arr = hi,
          varunit = 'ºC',
          varname = 'hi',
          longname = 'Huglin Index',
          lons = lon,
          lats = lat,
          inidate = '1980-01-01',
          scale = 'years',
          out = 'hi.nc')
 }

}
