% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frostProb.R
\name{frostProb}
\alias{frostProb}
\title{First day in the year where P(tmin<0) <= prob}
\usage{
frostProb(mn, dates, iniday = "07-01", endday = "06-30",
  type = "doy", thres = 0, prob = 0.1)
}
\arguments{
\item{mn}{vector of daily minimum temperature series.}

\item{dates}{vector of dates corresponding with daily temprature series}

\item{iniday}{first day of the year ("dd-mm") when frost occurrence will be considered.}

\item{endday}{last day of the year ("dd-mm") when frost occurrence will be considered.}

\item{type}{type of output. It can be "doy" for day of the year (julian day) or "date" for data format ("dd-mm").}

\item{thres}{temperature threshold considered to trigger frost occurrence (0 by default).}

\item{prob}{numeric. Threshold indicating the probability (0.10 by default)}
}
\value{
A numeric vector with the annual number of frost probability is returned.
}
\description{
Calculates the first day in the year where the probability if frost is under a threshold.
}
\details{
The function is able to span over years. If the argument "enddate" is a date earlier than "inidate", the considered period will cover from "inidate" to the end of the year and from the beginning of the next year to "enddate".#' @return depending on argument type, the output will be a numeric vector of julian days (type = "doy") or a vector of characters with dates (type = "date").
}
\examples{

frostProb(mn = daily_tmin,
  dates = seq.Date(as.Date('1981-01-01'),
                             as.Date('2010-12-31'), by ='day'),
  iniday = '07-01',
  endday = '06-30',
  type = 'date',
  prob = 0.10)

}
