% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahp_RI.R
\name{ahp.ri}
\alias{ahp.ri}
\title{Generate random indices}
\usage{
ahp.ri(nsims, dim, seed = 42)
}
\arguments{
\item{nsims}{Number of random pairwise comparison matrices to be generated. Processing time increases substantially with higher \code{nsims}.}

\item{dim}{Number of dimensions of the matrix.}

\item{seed}{The random number generator seed for reproducibility, which is same as \code{set.seed}. By default, \code{seed = 42}.}
}
\value{
The generated random index, which is numeric.
}
\description{
The \code{ahp.ri} function calculates the mean consistency indices of a specific numbers of random number pairwise comparison matrices.

The random index of one pairwise comparison matrix is given as below, where \eqn{lambda} is the maximum eigenvalue and \eqn{n} is the number of attributes.

\deqn{RI = (\lambda-n)/((n-1)}

\code{ahp.ri} creates \code{nsims} number of pairwise comparison matrices with number of dimensions=\code{dim}, and returns its average.
}
\examples{

ahp.ri(nsims = 10000, dim = 5, seed = 42)


}
\author{
Frankie Cho
}
