% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logProbabilityFeatureAllocation.R
\name{logProbabilityFeatureAllocation}
\alias{logProbabilityFeatureAllocation}
\title{Evaluation of a Log Probabilty Mass Function of a Feature Allocation Distribution}
\usage{
logProbabilityFeatureAllocation(
  featureAllocation,
  distribution,
  implementation = "scala"
)
}
\arguments{
\item{featureAllocation}{An N-by-K binary feature allocation matrix, or a list of such matrices.}

\item{distribution}{A feature allocation distribution as defined in the functions
\code{\link{aibd}} or \code{\link{ibp}}.}

\item{implementation}{The default of "scala" should be used.  The "R" option is not
a supported implementation.}
}
\value{
The log probability of the feature allocation under the supplied distribution.
}
\description{
This function evaluates the log of the probability mass function of a feature allocation
matrix or a list of feature allocations for the supplied distribution.
}
\examples{
\donttest{ # Regardless of size, the initial warmup can exceed CRAN's 5 seconds threshold
d1 <- ibp(1,4)

states <- c("California","Wisconsin","Nebraska","New York")
data <- USArrests[states,]
dist <- dist(scale(data))
d2 <- aibd(1, seq_along(states), 1.0, dist)

Z1 <- matrix(c(1,1,0,1), nrow=4)

logProbabilityFeatureAllocation(Z1, d1)
logProbabilityFeatureAllocation(Z1, d2)
}

}
