% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fct.R
\name{array_to_matrix}
\alias{array_to_matrix}
\title{Array to matrix}
\usage{
array_to_matrix(text_embedding)
}
\arguments{
\item{text_embedding}{\code{array} containing the text embedding. The array
should be created via an object of class \link{TextEmbeddingModel}.}
}
\value{
Returns a matrix which contains the cases in the rows and the columns
represent the features of all sequences. The sequences are concatenated.
}
\description{
Function transforming an array to a matrix.
}
\examples{
#text embedding is an array of shape (batch,times,features)
example_embedding<-c(1:24)
example_embedding<-array(example_embedding,dim=c(4,3,2))
example_embedding

#Transform array to a matrix
#matrix has shape (batch,times*features)
array_to_matrix(example_embedding)
}
\seealso{
Other Auxiliary Functions: 
\code{\link{calc_standard_classification_measures}()},
\code{\link{check_embedding_models}()},
\code{\link{clean_pytorch_log_transformers}()},
\code{\link{create_iota2_mean_object}()},
\code{\link{create_synthetic_units}()},
\code{\link{generate_id}()},
\code{\link{get_coder_metrics}()},
\code{\link{get_folds}()},
\code{\link{get_n_chunks}()},
\code{\link{get_stratified_train_test_split}()},
\code{\link{get_synthetic_cases}()},
\code{\link{get_train_test_split}()},
\code{\link{is.null_or_na}()},
\code{\link{matrix_to_array_c}()},
\code{\link{split_labeled_unlabeled}()},
\code{\link{summarize_tracked_sustainability}()},
\code{\link{to_categorical_c}()}
}
\concept{Auxiliary Functions}
