% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_DataManager.R
\name{create_synthetic_units_from_matrix}
\alias{create_synthetic_units_from_matrix}
\title{Create synthetic units}
\usage{
create_synthetic_units_from_matrix(
  matrix_form,
  target,
  required_cases,
  k,
  method,
  cat,
  k_s,
  max_k
)
}
\arguments{
\item{matrix_form}{Named \code{matrix} containing the text embeddings in matrix form. In most cases this object is taken
from \link{EmbeddedText}$embeddings.}

\item{target}{Named \code{factor} containing the labels/categories of the corresponding cases.}

\item{required_cases}{\code{int} Number of cases necessary to fill the gab between the frequency of the class under
investigation and the major class.}

\item{k}{\code{int} The number of nearest neighbors during sampling process.}

\item{method}{\code{vector} containing strings of the requested methods for generating new cases. Currently
"knnor" from this package is available.}

\item{cat}{\code{string} The category for which new cases should be created.}

\item{k_s}{\code{int} Number of ks in the complete generation process.}

\item{max_k}{\code{int} The maximum number of nearest neighbors during sampling process.}
}
\value{
Returns a \code{list} which contains the text embeddings of the new synthetic cases as a named \code{data.frame} and
their labels as a named \code{factor}.
}
\description{
Function for creating synthetic cases in order to balance the data for training with
\link{TEClassifierRegular} or \link{TEClassifierProtoNet}]. This is an auxiliary function for use with
\link{get_synthetic_cases_from_matrix} to allow parallel computations.
}
\seealso{
Other Utils Developers: 
\code{\link{auto_n_cores}()},
\code{\link{create_object}()},
\code{\link{generate_id}()},
\code{\link{get_n_chunks}()},
\code{\link{get_synthetic_cases_from_matrix}()},
\code{\link{get_time_stamp}()},
\code{\link{matrix_to_array_c}()},
\code{\link{tensor_to_matrix_c}()},
\code{\link{to_categorical_c}()}
}
\concept{Utils Developers}
