% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_utility.R
\name{PlotUtilityDiff}
\alias{PlotUtilityDiff}
\title{Plot utility difference}
\usage{
PlotUtilityDiff(res, idx = NULL)
}
\arguments{
\item{res}{The data frame generated from \code{CalUtilityDiff}.}

\item{idx}{The row index of observations to be included. The default is all the observations from the data.}
}
\value{
A ggplot.
}
\description{
See Figure 7 for example.
}
\examples{
\donttest{
data(synth)
sample_mcmc = AiEvalmcmc(data = synth, n.mcmc = 10)
synth_dmf = sample(0:1, nrow(synth), replace = TRUE) # random dmf recommendation
sample_utility = CalOptimalDecision(data = synth, mcmc.re = sample_mcmc, 
                                    c0.ls = seq(0,5,1), c1.ls = seq(0,5,1), 
                                    dmf = synth_dmf, size = 1) # adjust the size
PlotUtilityDiff(sample_utility)
}

}
