% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gene.R
\name{sortGenes}
\alias{sortGenes}
\title{Sort V(D)J genes}
\usage{
sortGenes(genes, method = c("name", "position"))
}
\arguments{
\item{genes}{vector of strings respresenting V(D)J gene names.}

\item{method}{string defining the method to use for sorting genes. One of:
\itemize{
  \item \code{"name"}:      sort in lexicographic order. Order is by 
                            family first, then gene, and then allele. 
  \item \code{"position"}:  sort by position in the locus, as
                            determined by the final two numbers 
                            in the gene name. Non-localized genes 
                            are assigned to the highest positions.
}}
}
\value{
A sorted character vector of gene names.
}
\description{
\code{sortGenes} sorts a vector of V(D)J gene names by either lexicographic ordering 
or locus position.
}
\examples{
# Create a list of allele names
genes <- c("IGHV1-69D*01","IGHV1-69*01","IGHV4-38-2*01","IGHV1-69-2*01",
           "IGHV2-5*01","IGHV1-NL1*01", "IGHV1-2*01,IGHV1-2*05", 
           "IGHV1-2", "IGHV1-2*02", "IGHV1-69*02")

# Sort genes by name
sortGenes(genes)

# Sort genes by position in the locus
sortGenes(genes, method="pos")

}
\seealso{
See \code{getAllele}, \code{getGene} and \code{getFamily} for parsing
          gene names.
}

