% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchPointsToLines.R
\name{matchPointsToLines}
\alias{matchPointsToLines}
\title{Match points to lines}
\usage{
matchPointsToLines(points, lines, getIndex = FALSE)
}
\arguments{
\item{points}{Points to attach.}

\item{lines}{Lines to attach to.}

\item{getIndex}{Get the index returned and not the data.}
}
\value{
If getIndex is TRUE then the index of the points as they relate to
the matching lines are given. If not, then the data from the points dataframe
is returned.
}
\description{
Match points to their closest line. Matches (spatial-join) points to lines.
Finds the point closest to a line. One point is attached to one line, thus if
fewer points than lines are given then some lines will have no point
attached.
}
\examples{
segmentsMif = system.file(
  "extdata", "testdata", "barnsbury",
  "barnsbury_small_segment_original.mif",
  package = "alcyon"
)
segmentsSf <- st_read(
  segmentsMif,
  geometry_column = 1L, quiet = TRUE
)
gateCountsMif = system.file(
  "extdata", "testdata", "barnsbury",
  "barnsbury_ped_gatecounts.mif",
  package = "alcyon"
)
gateCountsSf <- st_read(
  gateCountsMif,
  geometry_column = 1L, quiet = TRUE
)
matchPointsToLines(gateCountsSf, segmentsSf)
}
