% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PointMap.R
\docType{methods}
\name{unlinkCoords,PointMap-method}
\alias{unlinkCoords,PointMap-method}
\title{Unlink two PointMap Cells (coordinates)}
\usage{
\S4method{unlinkCoords}{PointMap}(map, fromX, fromY, toX, toY, copyMap = TRUE)
}
\arguments{
\item{map}{A PointMap}

\item{fromX}{X coordinate of the first unlink point}

\item{fromY}{Y coordinate of the first unlink point}

\item{toX}{X coordinate of the second unlink point}

\item{toY}{Y coordinate of the second unlink point}

\item{copyMap}{Optional. Copy the internal sala map}
}
\value{
A new PointMap with unlinked points
}
\description{
Unlink two cells on a PointMap using the point coordinates
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "gallery",
    "gallery_lines.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  pointMap <- makeVGAPointMap(
    sfMap,
    gridSize = 0.04,
    fillX = 3.01,
    fillY = 6.7,
    maxVisibility = NA,
    boundaryGraph = FALSE,
    verbose = FALSE
  )
pointMap <- linkCoords(pointMap, 1.74, 6.7, 5.05, 5.24)
pointMap <- unlinkCoords(pointMap, 1.74, 6.7, 5.05, 5.24)
}
