% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/baseline.R
\docType{methods}
\name{baseline_rollingball}
\alias{baseline_rollingball}
\alias{baseline_rollingball-method}
\alias{baseline_rollingball,numeric,numeric-method}
\alias{baseline_rollingball,ANY,missing-method}
\title{Rolling Ball Baseline Estimation}
\usage{
baseline_rollingball(x, y, ...)

\S4method{baseline_rollingball}{numeric,numeric}(x, y, m, s)

\S4method{baseline_rollingball}{ANY,missing}(x, m, s)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{m}{An odd \code{\link{integer}} giving the window size (i.e. the number of
adjacent points to be used; see \code{\link[=window_sliding]{window_sliding()}}) for
minimization/maximization.}

\item{s}{An odd \code{\link{integer}} giving the window size (i.e. the number of
adjacent points to be used; see \code{\link[=window_sliding]{window_sliding()}}) for smoothing.}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Rolling Ball Baseline Estimation
}
\note{
There will be \eqn{(m - 1) / 2} points both at the beginning and at the end
of the data series for which a complete \eqn{m}-width window cannot be
obtained. To prevent data loss, progressively wider/narrower windows are
used at both ends of the data series.
}
\examples{
## X-ray diffraction
data("XRD")

## Subset from 20 to 70 degrees
XRD <- signal_select(XRD, from = 20, to = 70)

## Plot spectrum
plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")

## Rolling Ball baseline
baseline <- baseline_rollingball(XRD, m = 201, s = 151)

plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")
lines(baseline, type = "l", col = "red")
}
\references{
Kneen, M. A. and Annegarn, H. J. (1996). Algorithm for Fitting XRF, SEM and
PIXE X-Ray Spectra Backgrounds. \emph{Nuclear Instruments and Methods in Physics
Research Section B: Beam Interactions with Materials and Atoms},
109/110: 209-213. \doi{10.1016/0168-583X(95)00908-6}.
}
\seealso{
\code{\link[=signal_correct]{signal_correct()}}

Other baseline estimation methods: 
\code{\link{baseline_linear}()},
\code{\link{baseline_peakfilling}()},
\code{\link{baseline_polynomial}()},
\code{\link{baseline_rubberband}()},
\code{\link{baseline_snip}()}
}
\author{
N. Frerebeau
}
\concept{baseline estimation methods}
