% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/alm_datepub.R
\name{alm_datepub}
\alias{alm_datepub}
\title{Get the date when the article was published.}
\usage{
alm_datepub(doi = NULL, pmid = NULL, pmcid = NULL, wos = NULL,
  scp = NULL, url = NULL, get = NULL, key = NULL,
  api_url = "http://alm.plos.org/api/v5/articles", ...)
}
\arguments{
\item{doi}{Digital object identifier for an article in PLoS Journals (character)}

\item{pmid}{PubMed object identifier (numeric)}

\item{pmcid}{PubMed Central object identifier (numeric)}

\item{wos}{Web of Science identifier (character)}

\item{scp}{Scopus identifier (character)}

\item{url}{Canonical URL (character)}

\item{get}{Get year, month, or day; if unspecified, whole date returned.}

\item{key}{your PLoS API key, either enter, or loads from .Rprofile (character)}

\item{api_url}{API endpoint, defaults to http://alm.plos.org/api/v3/articles (character)}

\item{...}{optional additional curl options (debugging tools mostly)}
}
\value{
Date when article was published.
}
\description{
Get the date when the article was published.
}
\examples{
\dontrun{
alm_datepub(doi='10.1371/journal.pone.0026871')
alm_datepub('10.1371/journal.pone.0026871', get='year')

# Provide more than one DOI
dois <- c('10.1371/journal.pone.0026871','10.1371/journal.pone.0048868',
		'10.1371/journal.pone.0048705','10.1371/journal.pone.0048731')
alm_datepub(doi=dois, get="month")
}
}
\references{
See a tutorial/vignette for alm at
\url{http://ropensci.org/tutorials/alm_tutorial.html}
}

