% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{compare_plot}
\alias{compare_plot}
\title{Comparison plot of train set and test set}
\usage{
compare_plot(.data, ...)
}
\arguments{
\item{.data}{an object of class "split_df", usually, a result of a call to split_df().}

\item{...}{one or more unquoted expressions separated by commas.
Select the variable you want to plotting.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, compare_category() will automatically
start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.}
}
\value{
There is no return value. Draw only the plot.
}
\description{
Plot compare information of the train set and test set included
in the "split_df" class.
}
\details{
The numerical variables are density plots and the categorical variables are
mosaic plots to compare the distribution of train sets and test sets.
}
\examples{
library(dplyr)

# Credit Card Default Data
head(ISLR::Default)

# Generate data for the example
sb <- ISLR::Default \%>\%
  split_by(default)

sb \%>\%
  compare_plot("income")

sb \%>\%
  compare_plot()
}
