% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calculate_sedac_groads}
\alias{calculate_sedac_groads}
\title{Calculate roads covariates}
\usage{
calculate_sedac_groads(
  from = NULL,
  locs = NULL,
  locs_id = NULL,
  radius = 1000,
  fun = "sum",
  geom = FALSE,
  ...
)
}
\arguments{
\item{from}{SpatVector(1). Output of \code{process_sedac_groads}.}

\item{locs}{data.frame, characater to file path, SpatVector, or sf object.}

\item{locs_id}{character(1). Column within \code{locations} CSV file
containing identifier for each unique coordinate location.}

\item{radius}{integer(1). Circular buffer distance around site locations.
(Default = 1000).}

\item{fun}{function(1). Function used to summarize the length of roads
within sites location buffer (Default is \code{sum}).}

\item{geom}{FALSE/"sf"/"terra".. Should the function return with geometry?
Default is \code{FALSE}, options with geometry are "sf" or "terra". The
coordinate reference system of the \code{sf} or \code{SpatVector} is that of \code{from.}}

\item{...}{Placeholders.}
}
\value{
a data.frame or SpatVector object
}
\description{
Prepared groads data is clipped with the buffer polygons
of \code{radius}. The total length of the roads are calculated.
Then the density of the roads is calculated by dividing
the total length from the area of the buffer. \code{terra::linearUnits()}
is used to convert the unit of length to meters.
}
\note{
Unit is km / sq km. The returned \code{data.frame} object contains a
\verb{$time} column to represent the temporal range covered by the
dataset. For more information, see \url{https://earthdata.nasa.gov/data/catalog/sedac-ciesin-sedac-groads-v1-1.00}.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
loc <- data.frame(id = "001", lon = -78.90, lat = 35.97)
calculate_sedac_groads(
  from = groads, # derived from process_sedac_groads() example
  locs = loc,
  locs_id = "id",
  radius = 1000,
  fun = "sum",
  geom = FALSE
)
}
}
\seealso{
\code{\link{process_sedac_groads}}
}
\author{
Insang Song
}
