% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{responses}
\alias{responses}
\alias{response}
\alias{response_404}
\alias{response_500}
\title{Plain Responses}
\usage{
response(body, headers = list(`Content-Type` = "text/html"), status = 200L)

response_404(
  body = "404: Not found",
  headers = list(`Content-Type` = "text/html"),
  status = 404L
)

response_500(
  body = "500: Server Error",
  headers = list(`Content-Type` = "text/html"),
  status = 500L
)
}
\arguments{
\item{body}{Body of response.}

\item{headers}{HTTP headers.}

\item{status}{Response status}
}
\description{
Plain HTTP Responses.
}
\examples{
app <- Ambiorix$new()

# html
app$get("/", function(req, res){
 res$send("hello!")
})

# text
app$get("/text", function(req, res){
 res$text("hello!")
})

if(interactive())
 app$start()

}
