###################################################
### chunk number 1: 
###################################################
library(amei)
options(width=65)


###################################################
### chunk number 2: 
###################################################
seed <- 12345
set.seed(seed)


###################################################
### chunk number 3: 
###################################################
true <- list(b=0.00218, k=10, nu=0.4, mu=0) 
init <- list(S0=762, I0=1, R0=0, D0=0) 
costs <- list(vac=2, death=4, infect=1)


###################################################
### chunk number 4: 
###################################################
vac <- list(frac=0, stop=0)


###################################################
### chunk number 5: 
###################################################
init.MCepi <- MCepi(init, true, vac, costs)


###################################################
### chunk number 6: epis
###################################################
plot(init.MCepi)


###################################################
### chunk number 7: costs
###################################################
plot(init.MCepi, type="costs")


###################################################
### chunk number 8: 
###################################################
vacgrid <- list(fracs=seq(0,1.0,0.1), stops=seq(2,init$S0-75,75)) 


###################################################
### chunk number 9: 
###################################################
out.optvac <- optvac(init, true, vacgrid, costs) 


###################################################
### chunk number 10: 
###################################################
best <- getpolicy(out.optvac) 
worst <-getpolicy(out.optvac, which="worst") 
rbind(best, worst) 


###################################################
### chunk number 11: optvac
###################################################
plot(out.optvac) 


###################################################
### chunk number 12: 
###################################################
vac.opt <- best[3:4]
opt.MCepi <- MCepi(init, true, vac.opt, costs)


###################################################
### chunk number 13: episov
###################################################
plot(opt.MCepi)


###################################################
### chunk number 14: costsov
###################################################
plot(opt.MCepi, type="costs")


###################################################
### chunk number 15: 
###################################################
getvac(opt.MCepi)


###################################################
### chunk number 16: 
###################################################
T <- length(opt.MCepi$Median$C)
optC <- getcost(opt.MCepi)
initC <- getcost(init.MCepi)
data.frame(rbind(initC,optC), row.names=c("init", "opt"))


###################################################
### chunk number 17: 
###################################################
opt.MCepi


###################################################
### chunk number 18: 
###################################################
out.man <- manage(init, epistep, vacgrid, costs) 


###################################################
### chunk number 19: epi
###################################################
plot(out.man)


###################################################
### chunk number 20: cost
###################################################
plot(out.man, type="cost")


###################################################
### chunk number 21: 
###################################################
getcost(out.man)


###################################################
### chunk number 22: params
###################################################
true <- as.list(formals(epistep)$true)
plot(out.man, type="params",true=true) 


###################################################
### chunk number 23: 
###################################################
out.man


###################################################
### chunk number 24: fracs
###################################################
plot(out.man, type="fracs")


###################################################
### chunk number 25: stops
###################################################
plot(out.man, type="stops")


###################################################
### chunk number 26: 
###################################################
out.MCmanage <- MCmanage(init, epistep, vacgrid, costs)


###################################################
### chunk number 27: MCmanepis
###################################################
plot(out.MCmanage)


###################################################
### chunk number 28: MCmancosts
###################################################
plot(out.MCmanage, type="costs")


###################################################
### chunk number 29: 
###################################################
getvac(out.MCmanage)


###################################################
### chunk number 30: MCmanfracs
###################################################
plot(out.MCmanage, type="fracs")


###################################################
### chunk number 31: MCmanstops
###################################################
plot(out.MCmanage, type="stops")


###################################################
### chunk number 32: 
###################################################
cinit <- getcost(init.MCepi)
copt <- getcost(opt.MCepi)
cman <- getcost(out.MCmanage)
data.frame(rbind(cinit, copt, cman), 
           row.names=c("init", "opt", "man"))


###################################################
### chunk number 33: 
###################################################
bad <- list(b=0.001, k=10, nu=0.9, mu=0)


###################################################
### chunk number 34: 
###################################################
costs.bad <- optvac(init, bad, vacgrid, costs)
pol.bad <- getpolicy(costs.bad)
pol.bad


###################################################
### chunk number 35: 
###################################################
bad.MCepi <- MCepi(init, true, pol.bad[3:4], costs)
cbad <- getcost(bad.MCepi)
cbad


