\name{plot.epiman}
\alias{plot.epiman}
\alias{plot.MCepi}

\title{ Plotting Epidemic Trajectories and Costs }
\description{
  These functions provide a visualization of the evolution
  of an epidemic, or multiple epidemics obtained via Monte
  Carlo, and the associated costs of the vaccination strategy
  employed
}
\usage{
\method{plot}{epiman}(x, type = c("epi", "costs", "params", "fracs", 
         "stops"), showd = FALSE, main = NULL, true = NULL, ...)
\method{plot}{MCepi}(x, type = c("epi", "costs", "fracs", "stops"), 
          showd = FALSE, showv = FALSE, main = NULL, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ the object to be plotted, either of class
    \code{"MCepi"} or \code{"epiman"}
  }
  \item{type}{ indicates the type of plot to be produced, including
    the epidemic trajectory/ies (\code{"epi"}, the default), cost(s),
    estimated distribution(s) of parameters (\code{"params"}, only
    in the case of \code{"epiman"}-class objects), the fraction
    vaccinated at each time step (\code{"fracs"}), and the
    vaccination (stopping) threshold (\code{"stops"})}
  \item{main}{ optional title argument for the plot.  If not specified,
    then an automatically generated default is used depending on the
    \code{type} of plot specified }
  \item{true}{ this argument only applies to \code{plot.epiman} with
    \code{type = "params"} where it should be a \code{list} with scalar
    entries \code{$b}, \code{$k}, \code{$nu}, and \code{$mu} indicating
    the true parameter entries for the evolution of the epidemic to be
    added (for comparison) to the posterior density plots }
  \item{showd}{ logical indicating if deaths should be
    shown in the trajectory plots when \code{type = "epi"} }
  \item{showv}{ this argument only applies to \code{plot.MCepi} with
    \code{type = "epi"} where it should be a logical indicating if
    vaccinations should be shown in the trajectory plot 
}  \item{\dots}{ additional arguments passed to \code{\link{plot}} } 
}
\details{
  The functions documented here support visualization
  of \code{"MCepi"}-class objects which are generated by the
  \code{\link{MCepi}} and \code{\link{MCmanage}} function,
  and \code{"epiman"}-class objects are
  generated by the \code{\link{manage}} function.  In both cases they
  enable a visualization of the evolution of the resulting epidemic(s)
  and costs associated with deaths, vaccinations, etc.
}
\value{
  The only output of this function is beautiful plots
}
\references{
\emph{A statistical framework for the adaptive management of 
epidemiological interventions} (2008). 
Daniel Merl, Leah R. Johnson, Robert B. Gramacy, and Marc S. Mangel.
Duke Working Paper 08-29.
\url{http://ftp.stat.duke.edu/WorkingPapers/08-29.html}
}
\author{
Daniel Merl <dan@stat.duke.edu>, 
Leah R. Johnson <leah@statslab.cam.ac.uk>, 
Robert B. Gramacy <bobby@statslab.cam.ac.uk>,
and Mark S. Mangel <msmangl@ams.ucsc.edu>
}
%\note{
% Bobby isn't sure why \code{showv} only exists for one of these
% two functions
%}
\seealso{ \code{\link{MCepi}}, \code{\link{manage}},
  \code{\link{MCmanage}} }
\examples{
## for examples of the usage of these functions,
## please see the documentation for the functions
## listed in the See Also section, above
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ hplot }
