% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rUV_rep_fc.R
\name{rUV_rep_fc}
\alias{rUV_rep_fc}
\title{Gibbs sampling of U and V}
\usage{
rUV_rep_fc(E.T,U,V,rho,s2=1,shrink=TRUE)
}
\arguments{
\item{E.T}{Array of square residual relational matrix series with additive
effects and covariates subtracted out. The third dimension of the array is
for different replicates. Each slice of the array according to the third
dimension is a square residual relational matrix.}

\item{U}{current value of U}

\item{V}{current value of V}

\item{rho}{dyadic correlation}

\item{s2}{dyadic variance}

\item{shrink}{adaptively shrink the factors with a hierarchical prior}
}
\value{
\item{U}{a new value of U} \item{V}{a new value of V}
}
\description{
A Gibbs sampler for updating the multiplicative effect matrices U and V,
assuming they are the same across replicates.
}
\author{
Peter Hoff, Yanjun He
}

